<?php
/*

#####################################################################################
# NIST-developed software is provided by NIST as a public service. You may use, 
# copy and distribute copies of the software in any medium, provided that you 
# keep intact this entire notice. You may improve, modify and create derivative 
# works of the software or any portion of the software, and you may copy and 
# distribute such modifications or works. Modified works should carry a notice 
# stating that you changed the software and should note the date and nature of 
# any such change. Please explicitly acknowledge the National Institute of 
# Standards and Technology as the source of the software.
# 
# NIST-developed software is expressly provided “AS IS.” NIST MAKES NO WARRANTY 
# OF ANY KIND, EXPRESS, IMPLIED, IN FACT OR ARISING BY OPERATION OF LAW, 
# INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS 
# FOR A PARTICULAR PURPOSE, NON-INFRINGEMENT AND DATA ACCURACY. NIST NEITHER 
# REPRESENTS NOR WARRANTS THAT THE OPERATION OF THE SOFTWARE WILL BE 
# UNINTERRUPTED OR ERROR-FREE, OR THAT ANY DEFECTS WILL BE CORRECTED. NIST DOES 
# NOT WARRANT OR MAKE ANY REPRESENTATIONS REGARDING THE USE OF THE SOFTWARE OR 
# THE RESULTS THEREOF, INCLUDING BUT NOT LIMITED TO THE CORRECTNESS, ACCURACY, 
# RELIABILITY, OR USEFULNESS OF THE SOFTWARE.
# 
# You are solely responsible for determining the appropriateness of using and 
# distributing the software and you assume all risks associated with its use, 
# including but not limited to the risks and costs of program errors, compliance 
# with applicable laws, damage to or loss of data, programs or equipment, and the 
# unavailability or interruption of operation. This software is not intended to 
# be used in any situation where a failure could cause risk of injury or damage 
# to property. The software developed by NIST employees is not subject to 
# copyright protection within the United States.
#####################################################################################
Author: James R. Lyle
*/
$page_title = "SS Home";
$page_h1 = "String Search Testing Home";
$isSsHome = 1; // setting this variable will help ft_ss_head.php in rendering the page as we call it next...
include "ft_ss_head.php";
?>
<div style="padding: 1em 1em 0.5em 1em; background: #eeeeee url(/images/ui-bg_highlight-soft_100_eeeeee_1x100.png) 50% top repeat-x;">
<p>Welcome to the Federated Testing for Forensic String Search Tools. These pages will guide 
you in testing a forensic string search tool. Use the selections from the left hand menu 
at any time to navigate to different parts of the testing process or to return to this page.</p>


<ol>
	<!--      <li>Select and download the string search test images from the <i>Federated Testing String Search</i>
section of the CFReDS website, https://www.cfreds.nist.gov.
There are two test images (.dd files).
one image is for testing search tools on
Microsoft Windows type file systems (FAT, ExFAT 
and NTFS) along with a block of unallocated storage space. The other 
test image is for testing searching UNIX-like file systems (OSX, APFS and ext4).
An HTML file is also included in the download. This file should be opened in
a browser on the test computer. The file can be used for entering search
target strings by copy and paste. This is helpful for entering non-English
text as a search target string.
</li>-->
<li>Download the string search data set from the <i>Federated Testing Test Data Sets</i>
section of the CFReDS website, <a href="https://www.cfreds.nist.gov">www.cfreds.nist.gov</a>. Copy the data set to your test computer 
(the computer where your forensic string search tool is installed). Unzip the data set and familiarize yourself with the contents. There are two test images (.dd files). One image is for testing search tools on
Microsoft Windows type file systems (FAT, ExFAT 
and NTFS) along with a block of unallocated storage space. The other 
test image is for testing searching UNIX-like file systems (OSX, APFS and ext4).
A string-search-test-cases.html HTML file is also included in the download. This file should be opened in
a browser on the test computer. The file can be used for entering search
target strings by copy and paste. This is helpful for entering non-English
text as a search target string. The ft-ss-07-Norm-strings.txt file should be used to copy and paste the target strings for test case FT-SS-07-Norm. The Expected Results by ID file can be printed and used to record the test results of each test case to paper as an intermediate step to recording the results in this test suite.
</li>
<li>Use the '<a href="/formatyourthumb.php?ref=ss">Format Your Log Drive FT-LOGS</a>' 
	page to prepare a flash drive for storing test logs.</li>
<li>From the list of defined string search test cases, select the test cases to run.
You do not have to run all the test cases.
You may want to omit any cases that are not relevent to the case work encountered
in your lab or test a feature not supported by your tool. 
For example, many tools do not support stemming search
(FT-SS-09-Stem), so this case can be skipped
most of the time. <--- would prefer this concept / directions / etc. to be part of the feature picker, not here.</li>
  <li>Install (if not already installed) the tool you want to
 test on either a lab computer
or a computer similar to the computers used in your lab. This is the 
Test Computer.</li>
<li>Make the test data set you downloaded from the CFReDS web-site readable by the tool
to be tested by either copying the file to the
test computer or locate the file on a removable drive
that can be attached to the test computer where you are running the searches.</li>
<li> You need to do some record
keeping before you start running test cases.
</ol>
	
	<ol style="margin-left: 40px">
	<li>Boot the Analysis Computer with the CFTT Federated Testing DVD.
	<li>Select <b>String Search</b>.
    <li>Select from the task menu: <b>Format FT-LOGS flash drive </b>to keep test logs.</li>
	<li>Select from the task menu: <b>Enter tool name and version</b> to record tool name and version.
	<li>Select from the task menu: <b>Identify Search Engine</b> to record the search engine being tested.
	This sets the search engine for the following tests until you select this task
	again and change the search engine.
	<li>Select from the task menu: <b>Select Test-Data Set</b> to record the data set (test image) being
	used.
	This sets the data set for the following tests until you select this task
	again and change the data set.
	</ol>

  <h2>Overview of Running a Test Case</h2>
  <h2>Running the Test Cases:</h2>
	Now, you are ready to run the selected test cases. The work flow is as follows:</li>
	<ol>
	<li>Select the <b>Run a Test Case</b> task from the task menu. This takes you to the
	<b>Test Case Selection Page</b></li>
	<li>From the <b>Test Case Selection Page</b> select the case you want to run and you will
	see two items for configuring the case:
	a collection of search tool settings and a set of search strings.</li>
	<li>You will also see a list of check boxes for recording hits reported in Active Files,
	Deleted Files and Unallocated Space.
	<li>Mark the check boxes corresponding to hits reported by the tool.</li>
	<li>There is a comment & observations box to record any observations
	for inclusion in the test report.
	<li>Use the <b>Save Results</b> button to record results.</li>
	</ol>
	  <p>Repeat the basic work flow for other search engines and test data sets.
	  <ol>
      <li>Run each selected test case and record results to the FT-LOGS flash drive.</li>
	  <li>If you are testing more than one search engine, use the task menu on the left
	  to set the next search engine to test and run the test cases again with the
	  new search engine.
	  <li>If you are using both test images, run everything again with the second
	  test image.
      <li>Select the <b>Generate a Test Report</b> task link to create a
	  draft test report skeleton on the log flash drive.<br>
      </li>
	  <li>Finalize the test report and submit (optional) to CFTT and share the results.
    </ol>

</p>
<br>
</div>

<?php
/*
*/
//include "ft_ss_home_links.php";
?>
<?php
	include "ft_ss_tail.php";
?>

